//
//  LicenseAgreementViewController.swift
//  HCSStudies
//
//  Created by Marvin Kowalewski on 21.06.23.
//

import Foundation
import UIKit

class LicenseAgreementViewController : UIViewController {
    

    //@IBOutlet var textLabel: LinkTextView!
    
    @IBOutlet var welcomeTextLabel: UILabel!
    
    @IBOutlet var welcomeTextStudyAppLabel: UILabel!
    
    @IBOutlet var agreeButton: UIButton!
    
    @IBOutlet var lblTermsAndConditions: UILabel!
    
    override func viewDidLoad() {
        
        super.viewDidLoad()
        
        var textArray_welcomeText = [String]()
        var fontArray_welcomeText = [UIFont]()
        var colorArray_welcomeText = [UIColor]()
        
        
        textArray_welcomeText.append("Willkommen bei")
        textArray_welcomeText.append("Human Centered Studies.")
        
        fontArray_welcomeText.append(Fonts.heavyFontWithSize(size: 17.0))
        fontArray_welcomeText.append(Fonts.heavyFontWithSize(size: 17.0))
        
        colorArray_welcomeText.append(Colors.greyColor)
        colorArray_welcomeText.append(Colors.carmine)
        
        self.welcomeTextLabel.attributedText = getAttributedString(arrayText: textArray_welcomeText, arrayColors: colorArray_welcomeText, arrayFonts: fontArray_welcomeText)
        
        welcomeTextStudyAppLabel.textColor = Colors.greyColor
        welcomeTextStudyAppLabel.font = Fonts.mediumFontWithSize(size: 17)
        welcomeTextStudyAppLabel.text = "Bei uns können Sie an Studien teilnehmen und damit einen Beitrag zu wissenschaftlichen Erhebungen leisten."
        
        var textArray = [String]()
        var fontArray = [UIFont]()
        var colorArray = [UIColor]()

        textArray.append("Mit der weiteren Nutzung akzeptiere ich die")
        textArray.append("AGB")
        textArray.append("und die")
        textArray.append("Datenschutzerklärung")
        textArray.append("dieser Studien App.")
        
        fontArray.append(Fonts.mediumFontWithSize(size: 17.0))
        fontArray.append(Fonts.heavyFontWithSize(size: 17.0))
        fontArray.append(Fonts.mediumFontWithSize(size: 17.0))
        fontArray.append(Fonts.heavyFontWithSize(size: 17.0))
        fontArray.append(Fonts.mediumFontWithSize(size: 17.0))
        
        colorArray.append(Colors.greyColor)
        colorArray.append(Colors.carmine)
        colorArray.append(Colors.greyColor)
        colorArray.append(Colors.carmine)
        colorArray.append(Colors.greyColor)
        
        self.lblTermsAndConditions.attributedText = getAttributedString(arrayText: textArray, arrayColors: colorArray, arrayFonts: fontArray)
        
        self.lblTermsAndConditions.isUserInteractionEnabled = true
        let tapgesture = UITapGestureRecognizer(target: self, action: #selector(tappedOnLabel(_ :)))
        tapgesture.numberOfTapsRequired = 1
        self.lblTermsAndConditions.addGestureRecognizer(tapgesture)
        
        
        // style agree Button
        agreeButton.titleLabel?.font = Fonts.mediumFontWithSize(size: 17)
        Utilities.styleFilledButtonAgreeConditionsEdged(agreeButton)
        
    }
    
    
    //MARK:- tappedOnLabel
    @objc func tappedOnLabel(_ gesture: UITapGestureRecognizer) {
        guard let text = self.lblTermsAndConditions.text else { return }
        
        let conditionsRange = (text as NSString).range(of: "die AGB und")
        let cancellationRange = (text as NSString).range(of: "Datenschutzerklärung")
        
        if gesture.didTapAttributedTextInLabel(label: self.lblTermsAndConditions, inRange: conditionsRange) {
            print("GeneralTermsAndConditionsNC")
            
            let storyboard = UIStoryboard(name: "Main", bundle: nil)
                    let navigationController = storyboard.instantiateViewController(withIdentifier: "GeneralTermsAndConditionsNC") as! UINavigationController
            
            navigationController.modalPresentationStyle = .popover
                
            present(navigationController, animated: true)
            
        } else if gesture.didTapAttributedTextInLabel(label: self.lblTermsAndConditions, inRange: cancellationRange){
            
            print("DataProtectionInformationNC")

            let storyboard = UIStoryboard(name: "Main", bundle: nil)
                    let navigationController = storyboard.instantiateViewController(withIdentifier: "DataProtectionInformationNC") as! UINavigationController
            
            navigationController.modalPresentationStyle = .popover
                
            present(navigationController, animated: true)
            
        }
    }

    func getAttributedString(arrayText:[String]?, arrayColors:[UIColor]?, arrayFonts:[UIFont]?) -> NSMutableAttributedString {
        
        let finalAttributedString = NSMutableAttributedString()
        
        for i in 0 ..< (arrayText?.count)! {
            
            let attributes = [NSAttributedString.Key.foregroundColor: arrayColors?[i], NSAttributedString.Key.font: arrayFonts?[i]]
            let attributedStr = (NSAttributedString.init(string: arrayText?[i] ?? "", attributes: attributes as [NSAttributedString.Key : Any]))
            
            if i != 0 {
                
                finalAttributedString.append(NSAttributedString.init(string: " "))
            }
            
            finalAttributedString.append(attributedStr)
        }
        
        return finalAttributedString
    }
    
    
    
    @IBAction func agreeButton(_ sender: Any) {
        UserDefaults.standard.set(false, forKey: "showLicenseAgreement_v0")
        
        let storyboard = UIStoryboard(name: "Main", bundle: nil)
        let tabBarController = storyboard.instantiateViewController(withIdentifier: "InitialTBC") as! UITabBarController
        
        self.view.window?.rootViewController = tabBarController
        self.view.window?.makeKeyAndVisible()
        
    }
}


struct Colors {
    
    static let carmine = UIColor.init(red: 169.0/255.0, green: 1.0/255.0, blue: 25.0/255.0, alpha: 1.0)
    
    static let greyColor = UIColor.init(red: 108.0/255.0, green: 108.0/255.0, blue: 108.0/255.0, alpha: 1.0)
    
    static let greenColor  = UIColor(red: 58/255, green: 181/255, blue: 78/255, alpha: 1.0)
}

struct Fonts {
    
    static func lightFontWithSize(size: CGFloat) -> UIFont {
        return UIFont(name:"Avenir-Light", size: size)!
    }
    
    static func heavyFontWithSize(size: CGFloat) -> UIFont {
        return UIFont(name:"Avenir-Heavy", size: size)!
    }
    
    static func mediumFontWithSize(size: CGFloat) -> UIFont {
        return UIFont(name:"Avenir-Medium", size: size)!
    }
}
